/**
 * ActionBlinking.java
 * v1.0
 * 
 * by Matija Tomaskovic
 * (mataya@unforgettable.com || http://www.foi.hr/~mtomasko)
 * 
 * Use this object for blinking action of BackBuffer object.
 * 
 *** Usage ***
 * 
 * 1. Create this object:
 * 
 *		ActionBlinking	a = new ActionBlinking(1000);	// initial blinking period is 1000ms
 * 
 * 2. Change blinking period whenever you want:
 * 
 *		a.m_lBlinkingPeriod = 500;	// in milliseconds
 * 
 * 3. When your object receives action() notification, do:
 * 
 *		a.doAction(lTimePassedSinceLastCall, bbYourObject, bbParentOfObject);
 * 
 *** LOG ***
 * 30.Dec.1999.
 * ~~~~~~~~~~~~
 *	14:32..	- created, and finalized version 1.0
 */

public class ActionBlinking
{
	
	public long m_lBlinkingPeriod = 1000;	// in milliseconds

	private long m_lBlinkingTime = 0;
	
	/** CONSTRUCTION *******************************************************/
	
	public ActionBlinking(long lBlinkingPeriod)
	{
		m_lBlinkingPeriod = lBlinkingPeriod;
	}

	/** ACTION HANDLER *****************************************************/
	
	public void doAction(long lTimeForAction,
						 BackBuffer bbObject, BackBuffer bbParent)
	{
		m_lBlinkingTime += lTimeForAction;
		lTimeForAction = 0;
			
		while (m_lBlinkingTime > m_lBlinkingPeriod)
		{
			// toggle visibility...
			if (bbObject.isVisible())
				bbParent.hideObject(bbObject);
			else
				bbParent.showObject(bbObject);
					
			m_lBlinkingTime -= m_lBlinkingPeriod;
		}
	}	
	
	public void reset()
	{
		m_lBlinkingTime = 0;
	}
}
