/**
 * FightGame.java
 * v1.0
 * 
 * by Matija Tomaskovic
 * (mataya@unforgettable.com || http://www.foi.hr/~mtomasko)
 * 
 *** LOG ***
 * 26.Dec.1999.
 * ~~~~~~~~~~~~
 *	14:05..	- created
 */

import java.awt.*;
import java.awt.image.*;
import java.awt.image.ImageObserver;
import java.util.Vector;


public class FightGame
	extends ActiveBackBuffer
{
	/** PARENT VARIABLES ***************************************************/
	
	ImageObserver	m_imob;
	Component		m_component;

	/** IMAGES (must be given by creator of this class) ********************/
	
	Image m_imgBackground;
	Image m_imgLife;
	
	Image m_imgBadGuyStanding;
	Image m_imgBadGuyDead;
	Image m_imgBadGuyDeadToEarly;
	Image m_imgBadGuyDying1;
	Image m_imgBadGuyDying2;
	Image m_imgBadGuyDying3;
	Image m_imgBadGuyDying4;
	Image m_imgBadGuyDying5;
	Image m_imgBadGuyTriggering1;
	Image m_imgBadGuyTriggering2;
	Image m_imgBadGuyTriggering3;
	Image m_imgBadGuyTriggering4;
	Image m_imgBadGuyShooting1;
	Image m_imgBadGuyShooting2;
	Image m_imgBadGuyShooting3;
	Image m_imgBadGuyShooting4;
		
	Image m_imgHat;
	Image m_imgHatDown;

	/** STATES & RESPONSES *************************************************/
	
	final static int STATE_INITIALIZING			= 0;
	final static int STATE_PLAYING				= 1;
	final static int STATE_END_OF_GAME			= 2;
	
	int m_iState = STATE_INITIALIZING;
	
	final static int RESPONSE_NONE				= 0;
	final static int RESPONSE_END_OF_GAME       = 1;
	
	int m_iResponse = RESPONSE_NONE;

	/**
	 * STATE_GET_READY
	 */

	final static int LIVES_X				= 10;
	final static int LIVES_Y				= 10;
	
	final static int GUY_Y					= 200;

	final static int MAX_LIVES				= 5;
	

	//
	// Objects
	//
	
	BackBuffer	m_bbLives[] = new BackBuffer[MAX_LIVES];
	
	BackBuffer	m_bbMouse = new BackBuffer();

	/**
	 * GAME PARAMETERS
	 */
	
	int m_iLives;				// current number of lives
	int m_iNewLives;			// number of bonus lives guy did in this game (is doing)
	
	private Vector m_Guys = new Vector(3);

	
	ActionToggle	m_toggler = new ActionToggle(300);
												 

	/** SOUND EFFECTS FLAGS ************************************************/
	
	boolean m_bSndPlayerGun = false;
	boolean m_bSndPlayerGunHat = false;

	
	/** CODE ***************************************************************/
	
	/**
	 * Constructor
	 */
	public FightGame(Component c, ImageObserver imob)
	{
		createForImage(c, imob);
		m_component = c;
		m_imob = imob;
	}
	

	/**
	 * Game initialization.
	 * Must be called once after creating this object, and after assigning all images.
	 * This will:
	 *	1, Initialize game variables and objects
	 *	2. Prepare for 1st level
	 *	3. Set STATE_GET_READY
	 */
	public void init()
	{
		setActionContinuous();
		
		// set background 
		this.setImage(m_imgBackground);

		// Prepare objects for lives
		int i;
		for (i = 0; i < MAX_LIVES; i++)
		{
			m_bbLives[i] = new BackBuffer();
			m_bbLives[i].createForImage(m_component, m_imob);
			m_bbLives[i].setImage(m_imgLife);
			m_bbLives[i].moveObject(LIVES_X + i * (m_bbLives[i].width + 1), LIVES_Y);
			addObject(m_bbLives[i]);
		}
	}
	
	/**
	 * Prepares this Hotel Game for specified level:
	 *	- clears current possible guys from Doors, and puts new ones..
	 */
	public void prepareForGame(int iLevel, int iLives)
	{
		m_iLives = iLives;
		m_iNewLives = 0;
		repaintLives();

		m_iResponse = RESPONSE_NONE;
		
		//
		// Delete all guys...
		//
		
		// turn off all guys..
		for (int i=0; i<m_Guys.size(); i++)
		{
			BadGuy guy = (BadGuy) m_Guys.elementAt(i);
			guy.dismiss(this);
		}		
		m_Guys.removeAllElements();
		
		
		//
		// we have 3 different formations
		//
		int iFormation = iLevel - 1;
		while (iFormation > 2)
			iFormation -= 3;

		//
		// Prepare guys
		//
		
		int guyY;
		int guyX;
		
		if (iFormation == 0)
		{
			guyY = GUY_Y;
			guyX = 100;
			BadGuy guy1 = createFighterBadGuy(iLevel);
			guy1.setStateStanding();
			guy1.moveObject(guyX, guyY);
			guy1.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy1);
			guy1.activate(this);

			guyY = GUY_Y;
			guyX = 400;
			BadGuy guy3 = createFighterBadGuy(iLevel);
			guy3.setStateStanding();
			guy3.moveObject(guyX, guyY);
			guy3.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy3);
			guy3.activate(this);
		}
		else if (iFormation == 1)
		{
			guyY = GUY_Y;
			guyX = 100;
			BadGuy guy1 = createFighterBadGuy(iLevel);
			guy1.setStateStanding();
			guy1.moveObject(guyX, guyY);
			guy1.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy1);
			guy1.activate(this);

			guyY = GUY_Y + 50;
			guyX = 250;
			BadGuy guy2 = createFighterBadGuy(iLevel);
			guy2.setStateStanding();
			guy2.moveObject(guyX, guyY);
			guy2.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy2);
			guy2.activate(this);

			guyY = GUY_Y;
			guyX = 400;
			BadGuy guy3 = createFighterBadGuy(iLevel);
			guy3.setStateStanding();
			guy3.moveObject(guyX, guyY);
			guy3.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy3);
			guy3.activate(this);
		}
		else
		{
			guyY = GUY_Y + 50;
			guyX = 50;
			BadGuy guy1 = createFighterBadGuy(iLevel);
			guy1.setStateStanding();
			guy1.moveObject(guyX, guyY);
			guy1.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy1);
			guy1.activate(this);

			guyY = GUY_Y;
			guyX = 200;
			BadGuy guy2 = createFighterBadGuy(iLevel);
			guy2.setStateStanding();
			guy2.moveObject(guyX, guyY);
			guy2.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy2);
			guy2.activate(this);

			guyY = GUY_Y;
			guyX = 350;
			BadGuy guy3 = createFighterBadGuy(iLevel);
			guy3.setStateStanding();
			guy3.moveObject(guyX, guyY);
			guy3.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy3);
			guy3.activate(this);
			
			guyY = GUY_Y + 50;
			guyX = 500;
			BadGuy guy4 = createFighterBadGuy(iLevel);
			guy4.setStateStanding();
			guy4.moveObject(guyX, guyY);
			guy4.setHat(m_imgHat, guyX + 14, guyY - 35, m_imgHatDown, m_imgHatDown);
			m_Guys.addElement(guy4);
			guy4.activate(this);
		}
		
		setStatePlaying();

	}
	
	private BadGuy createFighterBadGuy(int iLevel)
	{
		int level20 = iLevel;
		
		if (level20 > 20)
			level20 = 20;
		
		long lFirstTriggeringFrame = 600 - (500 * level20 / 20);
		long lTriggeringFrame = 400 - (300 * level20 / 20);
							   
		BadGuy	guy = new BadGuy(m_imgBadGuyStanding, m_imgBadGuyDead, m_imgBadGuyDeadToEarly, 5, 4, 5, m_component, m_imob);
		guy.setDyingFrame(0, m_imgBadGuyDying1, 0, 0, 100);
		guy.setDyingFrame(1, m_imgBadGuyDying2, 0, 0, 100);
		guy.setDyingFrame(2, m_imgBadGuyDying3, 0, 0, 100);
		guy.setDyingFrame(3, m_imgBadGuyDying4, 0, 0, 100);
		guy.setDyingFrame(4, m_imgBadGuyDying5, 0, 0, 100);
		guy.setTriggeringFrame(0, m_imgBadGuyTriggering1, 0, 0, lFirstTriggeringFrame);
		guy.setTriggeringFrame(1, m_imgBadGuyTriggering2, 0, 0, lTriggeringFrame);
		guy.setTriggeringFrame(2, m_imgBadGuyTriggering3, 0, 0, lTriggeringFrame);
		guy.setTriggeringFrame(3, m_imgBadGuyTriggering4, 0, 0, lTriggeringFrame);
		guy.setShootingFrame(0, m_imgBadGuyShooting4, 0, 0, 100);
		guy.setShootingFrame(1, m_imgBadGuyShooting3, 0, 0, 100);
		guy.setShootingFrame(2, m_imgBadGuyShooting2, 0, 0, 100);
		guy.setShootingFrame(3, m_imgBadGuyShooting1, 0, 0, 100);
		guy.setShootingFrame(4, m_imgBadGuyTriggering4, 0, 0, 300);
		guy.m_lMinStandingDelay = 2000 - (1000 * iLevel / 20);
		guy.m_lMaxStandingDelay = 8000 - (6000 * iLevel / 20);
		
		return guy;
	}

	/** ACTION *************************************************************/
	
	public void setStatePlaying()
	{
		m_iState = STATE_PLAYING;
	}
	
	public void setStateEndOfGame()
	{
		m_iState = STATE_END_OF_GAME;
		m_iResponse = RESPONSE_END_OF_GAME;
	}
	
	
	/**
	 * Main action routine - called periodically by applet's thread.
	 * After this, applet will call update() to show new stuff on screen.
	 */
	public long doContinuousAction(long lTimeForAction)
	{
		// blink lives
		m_toggler.doAction(lTimeForAction);
		if (m_toggler.m_bChanged)
		{
			repaintLives();
		}
		
		if (m_iState == STATE_PLAYING)
		{
			int i;
			
			// if player shooted...
			if (m_bMouseClicked)
			{
				m_bSndPlayerGun = true;
				
				m_bMouseClicked = false;
				
				for (i=0; i<m_Guys.size(); i++)
				{
					BadGuy guy = (BadGuy) m_Guys.elementAt(i);
					guy.onMouseClick(m_iMouseX, m_iMouseY);
				}
			}

			boolean bShootHat = false;
			
			// check if guy shoot the player..
			for (i=0; i<m_Guys.size(); i++)
			{
				BadGuy guy = (BadGuy) m_Guys.elementAt(i);
				
				if ((guy.m_iResponse == guy.RESPONSE_GUY_SHOOT) ||
					(guy.m_iResponse == guy.RESPONSE_GUY_IS_SHOT_TOO_EARLY))
				{
					m_bSndPlayerGun = true;
					setStateEndOfGame();
					return 0;
				}
				else if (guy.m_iResponse == guy.RESPONSE_HAT_IS_SHOT)
				{
					bShootHat = true;
					m_bSndPlayerGunHat = true;
					m_bSndPlayerGun = false;
					guy.m_iResponse = guy.RESPONSE_NONE;
				}
				else if (guy.m_iResponse == guy.RESPONSE_GUY_IS_SHOT)
				{
					if (m_iLives + m_iNewLives + 1 <= MAX_LIVES)
						m_iNewLives++;
					guy.m_iResponse = guy.RESPONSE_NONE;
					m_bSndPlayerGun = true;
				}
			}
			/*
			// if shoot hat - activate all guys..
			if (bShootHat)
			{
				for (i=0; i<m_Guys.size(); i++)
				{
					BadGuy guy = (BadGuy) m_Guys.elementAt(i);
					if (guy.m_iState == guy.STATE_STANDING)
						guy.setActionWhenTime(1);
				}
			}
			*/
		
			// check if game is finished...

			boolean bGameFinished = true;
			for (i=0; i<m_Guys.size(); i++)
			{
				BadGuy guy = (BadGuy) m_Guys.elementAt(i);

				if ((guy.m_iResponse != guy.RESPONSE_GUY_IS_DEAD) &&
					(guy.m_iResponse != guy.RESPONSE_GUY_SHOOT))
				{
					bGameFinished = false;
				}
			}
				
			if (bGameFinished)
			{
				setStateEndOfGame();
			}
		}
		else
		{
			// check for SFX
			for (int i=0; i<m_Guys.size(); i++)
			{
				BadGuy guy = (BadGuy) m_Guys.elementAt(i);
					
				if ((guy.m_iResponse == guy.RESPONSE_GUY_SHOOT) ||
					(guy.m_iResponse == guy.RESPONSE_GUY_IS_SHOT_TOO_EARLY))
				{
					m_bSndPlayerGun = true;
				}
				else if (guy.m_iResponse == guy.RESPONSE_HAT_IS_SHOT)
				{
					m_bSndPlayerGunHat = true;
				}
				else if (guy.m_iResponse == guy.RESPONSE_GUY_IS_SHOT)
				{
					m_bSndPlayerGun = true;
				}
				guy.m_iResponse = guy.RESPONSE_NONE;
			}
		}
		
		// return that all time was spent
		return 0;
	}


	
	/** MOUSE HANDLERS *****************************************************/

	// mouse indicators that are currently processed
	public int		m_iMouseX;
	public int		m_iMouseY;
	public boolean	m_bMouseClicked;		// true when clicked
	
	
	/**
	 * Paint life icons..
	 * When m_iLives is e.g. 2 - icon 0 and 1 will be painted
	 * and icon 2 may blink if STATE_READY_FOR_LIFE_LESS (user has just lost life)
	 */
	protected void repaintLives()
	{
		for (int i = 0; i < MAX_LIVES; i++)
		{
			if ((i >= m_iLives) && (i < m_iLives + m_iNewLives))
			{
				if (m_toggler.m_bFlag)
					showObject(m_bbLives[i]);
				else
					hideObject(m_bbLives[i]);
			}
			else if (i < m_iLives)
				showObject(m_bbLives[i]);
			else
				hideObject(m_bbLives[i]);
		}
	}
	
}
