/**
 * Hat.java
 * v1.0b
 * 
 * by Matija Tomaskovic
 * (mataya@unforgettable.com || http://www.foi.hr/~mtomasko)
 * 
 * Parachuter is used as small parachuter sprite for BackBuffer demo
 * 
 *** LOG ***
 * 28.Dec.1999. (MON)
 * ~~~~~~~~~~~~~~~~~~
 *	00:19..	- created
 */

import java.awt.*;
import java.awt.image.ImageObserver;


public class Hat
	extends ActiveBackBuffer
{
	
	final static int STATE_INACTIVE		= 1;
	final static int STATE_ON_HEAD		= 2;
	final static int STATE_SHOOTED		= 3;
	final static int STATE_ON_FLOOR		= 4;
	
	int m_iState = STATE_INACTIVE;
	
	Image	m_imgHat;
	int		m_iHatX;		// initial x position relative to guy's top-left
	int		m_iHatY;
	
	Image	m_imgHatDown;
	Image	m_imgHatDownScore;
	int		m_iHatDownY;
	
	public Hat(Image imgHat, int iInitX, int iInitY, Image imgHatDown, int iDownY, Image imgHatDownScore,
			   Component c, ImageObserver imob)
	{
		// initialize BackBuffer
		createForImage(c, imob);
		this.m_strName = "HAT";
		
		m_imgHat = imgHat;
		m_iHatX = iInitX;
		m_iHatY = iInitY;
		m_imgHatDown = imgHatDown;
		m_iHatDownY = iDownY;
		m_imgHatDownScore = imgHatDownScore;
		
		setStateOnHead();
	}

	public void setStateOnHead()
	{
		m_iState = STATE_ON_HEAD;
		setImage(m_imgHat);
		moveObject(m_iHatX, m_iHatY);
		setActionNone();
	}
	
	int m_iCurrentFrame = 0;
	int m_iTotalFrames = 10;
	long lMinFrameTime = 10;
	long lMaxFrameTime = 70;
	public void setStateShooted()
	{
		m_iState = STATE_SHOOTED;
		setImage(m_imgHatDown);
		moveObject(m_iHatX, m_iHatY);
		m_iCurrentFrame = 0;
		setActionWhenTime(lMaxFrameTime);
	}
	public void setStateShootedWithScore()
	{
		m_iState = STATE_SHOOTED;
		setImage(m_imgHatDownScore);
		moveObject(m_iHatX, m_iHatY);
		m_iCurrentFrame = 0;
		setActionWhenTime(300);
	}
	
	public void setStateOnFloor()
	{
		m_iState = STATE_ON_FLOOR;
		setActionNone();
	}
	
	public void doNextAction()
	{
		if (m_iState == STATE_SHOOTED)
			doStateShooted();
		else
			setActionNone();
	}
	
	private void doStateShooted()
	{
		setImage(m_imgHatDown);
		m_iCurrentFrame++;
		
		if (m_iCurrentFrame <= m_iTotalFrames)
		{
			moveObject(m_iHatX, m_iHatY + ((m_iHatDownY - m_iHatY) * m_iCurrentFrame / m_iTotalFrames));
			setActionWhenTime(lMaxFrameTime - (lMaxFrameTime - lMinFrameTime)*m_iCurrentFrame/m_iTotalFrames);
		}
		else
		{
			setStateOnFloor();
		}
	}
}
