/**
 *
 * ImageFrames.java
 * 
 * Project:	Disney Hotel Game
 *
 * Author:	Matija Tomaskovic
 *
 *** DESCRIPTION & USAGE ***
 *		
 * This class represents collection of images with associated delays (times),
 * and coordinates that makes animation.
 *
 * To use it, do following:
 * 
 * 1. Create instance of this object:
 *	
 *		ImageFrames imgFrames = new ImageFrames(10);
 * 
 * 2. Add optional number of frames:
 * 
 *		imgFrames.setFrame(0, myImage1, 0, 0, 100);
 *		imgFrames.setFrame(1, myImage2, 10, 20, 150);
 *		:
 *		: max. to:
 *		imgFrames.setFrame(9, myImage9, 30, 20, 150);	// 9 (10-1) is maximum number!
 * 
 * Frames must be added sequentially - e.g. if frame 2 (N) is added, 
 * frame 1 (N-1) and all before it must also exist.
 *
 *** LOG ***
 * 
 * 23.Dec.1999.
 * ~~~~~~~~~~~~
 *	19:23..	- created
 *
 */

import java.awt.*;
import java.awt.image.*;
import java.awt.image.ImageObserver;

public class ImageFrames
{
	int		m_iMaxFrames;
	
	Image	m_images[];
	long	m_delays[];
	int		m_x[];
	int		m_y[];
	
	int		m_iCount;		// number of frames..
	int		m_iCurrentFrame;
	
	/** INITIALIZATION *****************************************************/

	/**
	 * Construction
	 */
	public ImageFrames(int iMaxFrames)
	{
		// create array
		m_iMaxFrames = iMaxFrames;
		m_images = new Image[m_iMaxFrames];
		m_delays = new long[m_iMaxFrames];
		m_x = new int[m_iMaxFrames];
		m_y = new int[m_iMaxFrames];
	}
	
	/**
	 * Sets image and delay (time to wait for that frame) for frame
	 */
	public void setFrame(int iFrame, Image imgFrame, int x, int y, long lDelay)
	{
		// if array to small - ignore
		if (iFrame >= m_iMaxFrames)
			return;
		
		m_images[iFrame] = imgFrame;
		m_delays[iFrame] = lDelay;
		m_x[iFrame] = x;
		m_y[iFrame] = y;
		
		if (iFrame >= m_iCount)
			m_iCount = iFrame + 1;
	}
	
	
	/**
	 * Moves to next frame.
	 * @return false if no more frames
	 */
	public boolean nextFrame()
	{
		if (m_iCurrentFrame+1 >= m_iCount)
			return false;
		
		m_iCurrentFrame++;
		return true;
	}
	
	/** QUERIES ************************************************************/

	public Image getCurrentImage()
	{
		return m_images[m_iCurrentFrame];
	}
	
	public long getCurrentDelay()
	{
		return m_delays[m_iCurrentFrame];
	}
	
	public int getCurrentX()
	{
		return m_x[m_iCurrentFrame];
	}
	
	public int getCurrentY()
	{
		return m_y[m_iCurrentFrame];
	}
}
