/**
 * 
 * Class:	RectangleManager
 * 
 * Author:	Matija Tomaskovic 
 *			mataya@unforgettable.com || http://www.foi.hr/~mtomasko
 * 
 * Description:
 *		RectangleManager represents class to handle bunch of rectangles.
 *		It's purpose is to provide some specific functions concerning
 *		handling colletion of rectangles.
 * 
 *** LOG ***
 * 15.Dec.1999. (WED)
 * ~~~~~~~~~~~~~~~~~~
 *	18:59	- created
 */

import java.awt.*;
import java.awt.image.*;

public class RectangleManager
{
	// dynamic array for storing rectangles:
	
	RectangleManagerRect m_RectangleList;	// Linked list of rectangles
	
	/**
	 * Constructor
	 */
	public RectangleManager()
	{
		// m_RectangleList = null;
	}
	
	/**
	 * Adds given rectangle to repaint list (into rectangle array)
	 */
	protected void addRectangle(int iX, int iY, int iWidth, int iHeight)
	{
		RectangleManagerRect r = new RectangleManagerRect();
		r.x = iX;
		r.y = iY;
		r.width = iWidth;
		r.height = iHeight;
		
		// add it to list..
		r.m_next = m_RectangleList;
		m_RectangleList = r;
	}
	
	
	/**
	 * Deletes all rectangles from RectangleManager.
	 * (actually, rectangles are not deleted but its count is set to zero,
	 * and they will be ovewriten by new AddRectangle's)
	 */
	public void deleteAll()
	{
		/*
		RectangleManagerRect r, rNext;
		r = m_RectangleList;
		while(r != null)
		{
			rNext = r.m_next;
			finalize(
		}
		*/
		// hoping GarbageCollector will do its job...
		m_RectangleList = null;
	}
	
	
	/**
	 * This function optimizes rectangles for painting...
	 * Initially, there are m_iRectCount rectangles to repaint.
	 * This function will merge (make union of) all two rectangles
	 * that intersects - and recursively, it will make union of 
	 * rectangles that intersects with some union.
	 * Final result is hopefully less rectangles to repaint.
	 */
	public void optimizeForRepaint()
	{
		RectangleManagerRect r1;
		RectangleManagerRect r2;
		RectangleManagerRect r2prev;
		boolean bIntersectionFound = true;

		// go first time, and rescan while intersections found..
		while(bIntersectionFound)
		{
			bIntersectionFound = false;
		
			// for every rectangle
			r1 = m_RectangleList;
			while(r1 != null)
			{
				r2 = r1.m_next;
				r2prev = r1;
				// check if any rectangle intersects him..
				while(r2 != null)
				{
					// if these two intersects..
					if (r1.intersects(r2))
					{
						r1.unionWith(r2);
						
						// and remove second one from list...
						// (hoping that GarbageCollector will do the job...)
						r2prev.m_next = r2.m_next;
						
						bIntersectionFound = true;
					}

					r2prev = r2;
					r2 = r2.m_next;
				}
				
				r1 = r1.m_next;
			}
		}
	}
}
