/**
 * Class:	RectangleManagerRect
 * 
 * Author:	Matija Tomaskovic
 * 
 * Description:	Represents rectangles to be used by RectangleManagerRect
 *		(as linked list)
 * 
 *** LOG ***
 * 15.Dec.1999. (WED)
 * ~~~~~~~~~~~~~~~~~~
 *	19:40..	- created
 */

import java.awt.*;


public class RectangleManagerRect 
	extends Rectangle
{
	RectangleManagerRect m_next = null;
	

	/** CONSTRUCTION **********************************************************/

	public RectangleManagerRect()
	{
		// x = 0;
		// y = 0;
		// width = 0;
		// height = 0;
	}
	
	public RectangleManagerRect(int iX, int iY, int iWidth, int iHeight)
	{
		x = iX;
		y = iY;
		width = iWidth;
		height = iHeight;
	}
	
	/** UTILITY ************************************************************/

	
	public void setPosAndSize(int iX, int iY, int iWidth, int iHeight)
	{
		x = iX;
		y = iY;
		width = iWidth;
		height = iHeight;
	}
	
	/**
	 * public boolean boundToRect(Rectangle r)
	 * 
	 * Description
	 *		Bounds this rectangle to inside borders of specified one.
	 * 
	 * Return value
	 *		true if this rectangle was successfully bounded inside given rect
	 *		false if this rectangle is outside specified rect
	 */
	public boolean boundToRect(Rectangle r)
	{
		// check if this rectangle is outside given one...
		if (!intersects(r))
			return false;
		
		// they do intersect - so crop this to r-one.
		
		if (x < r.x)
		{
			width = width - (r.x - x);
			x = r.x;
		}
		
		if (y < r.y)
		{
			height = height - (r.y - y);
			y = r.y;
		}
		
		if (x + width > r.x + r.width)
			width = (r.x + r.width) - x;
		
		if (y + height > r.y + r.height)
			height = (r.y + r.height) - y;
		
		return true;
	}
	
	/**
	 * Makes this rectangle as union of himself and given one
	 */
	public void unionWith(Rectangle r)
	{
		if (x > r.x)
		{
			width = width + x - r.x;
			x = r.x;
		}
						
		if (y > r.y)
		{
			height = height + y - r.y;
			y = r.y;
		}
						
		if (x + width < r.x + r.width)
			width = (r.x + r.width) - x;
						
		if (y + height < r.y + r.height)
			height = (r.y + r.height) - y;
	}
}
